# <img src="man/figures/logo.jpg" align="right" width="120" />

[![CRAN_Status_Badge](https://www.r-pkg.org/badges/version/otargen?color=blue)](https://CRAN.R-project.org/package=otargen)
[![Downloads](https://cranlogs.r-pkg.org/badges/otargen?color=yellow)](https://CRAN.R-project.org/package=otargen)
[![License](https://img.shields.io/badge/License-MIT-blue.svg?color=green)](https://opensource.org/licenses/MIT)
[![Build Status](https://app.travis-ci.com/your-username/your-repository.svg?branch=master)](https://app.travis-ci.com/your-username/your-repository)



## Streamlined Tidy Data Access to Open Target Genetics GraphQL API🔍
`otargen` is an open-source R package for easy data retrieval and analysis from [Open Target Genetics](https://genetics.opentargets.org). It brings simplicity in scale to analsye human genetic evidances for gene-trait/diseases associations from R environment, enhancing your research with advanced data handling and visualization tools.

:loudspeaker: `otargenpy`  is available for python users :snake: `pip install otargenpy`

Check out the repository here: [otargenpy on GitHub](https://github.com/amirfeizi/otargenpy). `otargenpy` has all the capabilities of `otargen`, We encourage you to try it out and provide us with feedback!

### Key Features
🚀 **Effortless Data Retrieval**: Easily access and transform complex GraphQL queries.

📈 **Insightful Visualizations**: Clearly visualize complex datasets with intuitive plots.

📖 **Comprehensive Documentation**: Well-documented functions for easy integration.

👨‍💻 **Regular Updates**: Stay updated with new features and improvements.



### Installation
Get started with `otargen` from CRAN:

```r
install.packages("otargen")
```
Or install the latest development version from GitHub:
```
if (!require("devtools")) install.packages("devtools")
devtools::install_github("https://github.com/amirfeizi/otargen.git")
```

### Citing otargen :raising_hand_man:
Please cite `otargen` if you use it in your research. [Bioinformatics](https://doi.org/10.1093/bioinformatics/btad441).

```
Feizi, Amir, and Kamalika Ray. "otargen: GraphQL-based R package for tidy data accessing and processing from Open Targets Genetics." Bioinformatics 39.8 (2023): btad441.
```

### Community and Contributions
Join the `otargen` community on [GitHub](https://github.com/amirfeizi/otargen) and contribute to its growth. We welcome bug reports, feature suggestions, and code contributions.


