% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLociGenes.R
\name{get_genes}
\alias{get_genes}
\title{Retrieve summary information of the genes in a locus}
\usage{
get_genes(chromosome, start, end)
}
\arguments{
\item{chromosome}{Character: Chromosome number as a string.}

\item{start}{Integer: Start position of the specified region on the chromosome.}

\item{end}{Integer: End position of the specified region on the chromosome.}
}
\value{
Returns a tibble data frame of all the overlapping genes in the specified region with the following data structure:
\itemize{
  \item{\code{id}:} \emph{Character}. ID of the gene.
  \item{\code{symbol}:} \emph{Character}. Symbol of the gene.
  \item{\code{bioType}:} \emph{Character}. Biotype of the gene.
  \item{\code{description}:} \emph{Character}. Description of the gene.
  \item{\code{chromosome}:} \emph{Character}. Chromosome of the gene.
  \item{\code{tss}:} \emph{Integer}. Transcription start site of the gene.
  \item{\code{start}:} \emph{Integer}. Start position of the gene.
  \item{\code{end}:} \emph{Integer}. End position of the gene.
  \item{\code{fwdStrand}:} \emph{Logical}. Strand direction of the gene.
  \item{\code{exons}:} \emph{List}. List of exons of the gene.
}
}
\description{
This function retrieves information for a specified region on a chromosome, including overlapping genes and their
associated details such as ID, symbol, biotype, description,
 transcription start site (TSS), start position, end position, strand direction, and exons structure.
}
\examples{
\dontrun{
result <- get_genes(chromosome = "2", start = 239634984, end = 241634984)
}
}
