% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmTrip.R
\name{osrmTrip}
\alias{osrmTrip}
\title{Get the Travel Geometry Between Multiple Unordered Points}
\usage{
osrmTrip(loc, exclude = NULL, overview = "simplified", returnclass = "sp")
}
\arguments{
\item{loc}{a SpatialPointsDataFrame or an sf object of the waypoints, or a data.frame with points as rows
and 3 columns: identifier, longitudes and latitudes (WGS84 decimal degrees).}

\item{exclude}{pass an optional "exclude" request option to the OSRM API.}

\item{overview}{"full", "simplified". Add geometry either full (detailed) or simplified 
according to highest zoom level it could be display on.}

\item{returnclass}{if returnclass="sf" an sf LINESTRING is returned. 
If returnclass="sp" a SpatialLineDataFrame is returned.}
}
\value{
A list of connected components. Each component contains:

\describe{
\item{trip}{A SpatialLinesDataFrame or sf LINESTRING (loc's CRS if there is one, WGS84 if not)
containing a line for each step of the trip.}
\item{summary}{A list with 2 components: duration (in minutes)
and distance (in kilometers).}
}
}
\description{
Build and send an OSRM API query to get the shortest travel geometry between multiple points.
This function interfaces the \emph{trip} OSRM service.
}
\details{
As stated in the OSRM API, if input coordinates can not be joined by a single trip 
(e.g. the coordinates are on several disconnecte islands) multiple trips for 
each connected component are returned.
}
\examples{
\dontrun{
# Load data
data("berlin")
library(sf)
# Get a trip with a set of points (sf POINT)
trips <- osrmTrip(loc = apotheke.sf, returnclass = "sf")
mytrip <- trips[[1]]$trip
# Display the trip
plot(st_geometry(mytrip), col = "black", lwd = 4)
plot(st_geometry(mytrip), col = c("red", "white"), lwd = 1, add = TRUE)
plot(st_geometry(apotheke.sf), pch = 21, bg = "red", cex = 1, add = TRUE)
}
}
\seealso{
\link{osrmRoute}
}
