% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmTable.R
\name{osrmTable}
\alias{osrmTable}
\title{Get Travel Time Matrices Between Points}
\usage{
osrmTable(df, id, x, y)
}
\arguments{
\item{df}{data frame containing points identifiers, longitudes and latitudes 
(WGS84).}

\item{id}{identifier field in df.}

\item{x}{longitude field in df.}

\item{y}{latitude field in df.}
}
\value{
x A square matrix of time travel (in minutes) is returned.
}
\description{
Build and send OSRM API queries to get travel time matrices between points. 
This function interface the \emph{table} OSRM service.
}
\note{
The public OSRM API does not allow more than 100 
locations in distance table query. \cr
If you use an other OSRM API service, make sure that 
more than 100 locations are allowed in table queries 
(i.e. the "max-table-size" argument, Max. locations supported in distance 
table query).
}
\examples{
\dontrun{ 
# Load data
data("com")
# Travel time matrix
distcom <- osrmTable(com[1:50,], id = "comm_id", x =  "lon",y =  "lat")
# First 5 rows and columns
distcom[1:5,1:5]
}
}
\seealso{
\link{osrmTableOD}, \link{osrmTableErrors}
}

