% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmose.interannual-fishing.R
\name{getFishingBaseRate}
\alias{getFishingBaseRate}
\title{Get fishing base rate.}
\usage{
getFishingBaseRate(sp, fishing, T, ndt)
}
\arguments{
\item{sp}{Current specie (sp0, sp1, etc.)}

\item{fishing}{Fishing parameters}

\item{T}{Number of years}

\item{ndt}{Time step}
}
\description{
Get fishing base rate.
}
\details{
It assumes that in the Osmose configuration, there is a "fishing" entry.
It first check for the "method" parameter for the current
specie (\emph{mortality.fishing.rate.method.spX}), whose value can be

\itemize{
\item{constant: use \emph{rate.spX}}
\item{byRegime: use \emph{rate.byRegime.file.spX}}
\item{linear  : use \emph{rate.slope.spX}}
\item{byYear  : use \emph{rate.byYear.spX}}
\item{byDt    : use \emph{rate.byDt.spX}}
}
}
\examples{
{
filename = system.file("extdata", "data_fishing.csv", package="osmose")
conf = readOsmoseConfiguration(filename)
ndt = getOsmoseParameter(conf, "simulation", "time", "ndtperyear")
nyear = getOsmoseParameter(conf, "simulation", "time", "nyear")

fishing = conf$mortality$fishing

fish0 = getFishingBaseRate("sp0", fishing, nyear, ndt)
}
}
