/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.util.version;

import fr.ird.osmose.Configuration;
import fr.ird.osmose.Osmose;
import fr.ird.osmose.util.logging.OLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public abstract class AbstractVersion
extends OLogger
implements Comparable<AbstractVersion> {
    private final int number;
    private final int update;
    private final String date;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");

    abstract void updateParameters();

    AbstractVersion(int number, int update, int year, int month, int day) {
        this.number = number;
        this.update = update;
        Calendar cld = Calendar.getInstance();
        cld.set(year, month, day);
        this.sdf.setCalendar(cld);
        this.date = this.sdf.format(cld.getTime());
    }

    void updateConfiguration() {
        this.info("Updating configuration file to " + this.toString() + "...");
        this.updateParameters();
        this.updateValue("osmose.version", this.toString());
    }

    public int getNumber() {
        return this.number;
    }

    public int getUpdate() {
        return this.update;
    }

    public String getDate() {
        return this.date;
    }

    public String toString() {
        StringBuilder version = new StringBuilder("Osmose ");
        version.append(this.number);
        if (this.update > 0) {
            version.append(" Update ");
            version.append(this.update);
        }
        version.append(" (");
        version.append(this.date);
        version.append(")");
        return version.toString();
    }

    @Override
    public int compareTo(AbstractVersion otherVersion) {
        if (this.number != otherVersion.getNumber()) {
            return Integer.compare(this.number, otherVersion.getNumber());
        }
        if (this.update != otherVersion.getUpdate()) {
            return Integer.compare(this.update, otherVersion.getUpdate());
        }
        return 0;
    }

    protected void addParameter(String key, String value) {
        if (this.getConfiguration().canFind(key)) {
            StringBuilder warning = new StringBuilder();
            warning.append("  Did not add parameter ");
            warning.append(key);
            warning.append(" as it is already defined in file ");
            warning.append(this.getConfiguration().getSource(key));
            this.info(warning.toString());
            return;
        }
        String pattern = key;
        String source = this.getConfiguration().getMainFile();
        while (pattern.contains(".")) {
            pattern = pattern.substring(0, pattern.lastIndexOf(".")) + "*";
            List<String> keys = this.getConfiguration().findKeys(pattern);
            if (keys.isEmpty()) continue;
            source = this.getConfiguration().getSource(keys.get(0));
            break;
        }
        this.backup(source);
        StringBuilder parameter = new StringBuilder();
        parameter.append(key);
        parameter.append(this.getConfiguration().getDefaultSeparator());
        parameter.append(value);
        ArrayList<String> parameters = this.getLines(source);
        StringBuilder msg = new StringBuilder();
        msg.append(this.toString());
        msg.append(" Added parameter ");
        msg.append((CharSequence)parameter);
        parameters.add("# " + msg.toString());
        parameters.add(parameter.toString());
        msg.append(" (");
        msg.append(source);
        msg.append(")");
        this.info(" " + msg.substring(msg.indexOf(")") + 1));
        this.write(source, parameters);
    }

    private int findLine(String key, ArrayList<String> parameters) {
        int iline = -1;
        for (int i = 0; i < parameters.size(); ++i) {
            if (!parameters.get(i).startsWith(key)) continue;
            iline = i;
            break;
        }
        return iline;
    }

    protected void deprecateParameter(String key) {
        this.commentParameter(key, "Deprecated parameter " + key);
    }

    protected void commentParameter(String key, String comment) {
        if (!this.getConfiguration().canFind(key)) {
            return;
        }
        String source = this.getConfiguration().getSource(key);
        this.backup(source);
        ArrayList<String> parameters = this.getLines(source);
        int iline = this.findLine(key, parameters);
        String deprecated = "# " + parameters.get(iline);
        parameters.set(iline, deprecated);
        StringBuilder msg = new StringBuilder();
        msg.append(this.toString());
        msg.append(" ");
        msg.append(comment);
        parameters.add(iline, "# " + msg);
        msg.insert(0, "  ");
        msg.append(" (");
        msg.append(source);
        msg.append(")");
        this.info(" " + msg.substring(msg.indexOf(")") + 1));
        this.write(source, parameters);
    }

    protected void updateKey(String key, String newKey) {
        if (this.getConfiguration().canFind(newKey)) {
            StringBuilder msg = new StringBuilder();
            msg.append("  Did not rename ");
            msg.append(key);
            msg.append(" into ");
            msg.append(newKey);
            msg.append(" as it is already defined in file");
            msg.append(this.getConfiguration().getSource(newKey));
            this.info(msg.toString());
            this.commentParameter(key, msg.toString());
            return;
        }
        if (!this.getConfiguration().canFind(key)) {
            StringBuilder warning = new StringBuilder();
            warning.append("  Did not rename ");
            warning.append(key);
            warning.append(" into ");
            warning.append(newKey);
            warning.append(" as it is not defined in your configuration.");
            this.info(warning.toString());
            return;
        }
        String source = this.getConfiguration().getSource(key);
        this.backup(source);
        ArrayList<String> parameters = this.getLines(source);
        int iline = this.findLine(key, parameters);
        String updatedParameter = parameters.get(iline).replace(key, newKey);
        parameters.set(iline, updatedParameter);
        StringBuilder msg = new StringBuilder();
        msg.append(this.toString());
        msg.append(" Renamed parameter ");
        msg.append(key);
        msg.append(" into ");
        msg.append(newKey);
        parameters.add(iline, "# " + msg);
        msg.insert(0, "  ");
        msg.append(" (");
        msg.append(source);
        msg.append(")");
        this.info(" " + msg.substring(msg.indexOf(")") + 1));
        this.write(source, parameters);
    }

    protected void updateValue(String key, String newValue) {
        if (!this.getConfiguration().canFind(key)) {
            this.addParameter(key, newValue);
            return;
        }
        if (this.getConfiguration().getString(key).matches(newValue)) {
            StringBuilder warning = new StringBuilder();
            warning.append("  Did not update ");
            warning.append(key);
            warning.append(" value as it is already up-to-date.");
            this.info(warning.toString());
            return;
        }
        String source = this.getConfiguration().getSource(key);
        this.backup(source);
        ArrayList<String> parameters = this.getLines(source);
        int iline = this.findLine(key, parameters);
        String value = this.getConfiguration().getString(key);
        String updatedParameter = parameters.get(iline).replace(value, newValue);
        parameters.set(iline, updatedParameter);
        StringBuilder msg = new StringBuilder();
        msg.append(this.toString());
        msg.append(" Updated parameter ");
        msg.append(key);
        msg.append(" to ");
        msg.append(newValue);
        parameters.add(iline, "# " + msg);
        msg.insert(0, "  ");
        msg.append(" (");
        msg.append(source);
        msg.append(")");
        this.info(" " + msg.substring(msg.indexOf(")") + 1));
        this.write(source, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(String file, ArrayList<String> lines) {
        BufferedWriter bfr = null;
        try {
            bfr = new BufferedWriter(new FileWriter(file));
            for (String line : lines) {
                bfr.append(line);
                bfr.newLine();
            }
            bfr.close();
        }
        catch (IOException ex) {
            this.error("Error writing configuration file " + file, ex);
        }
        finally {
            try {
                bfr.flush();
            }
            catch (IOException iOException) {}
        }
    }

    protected ArrayList<String> getLines(String file) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            BufferedReader bfr = new BufferedReader(new FileReader(file));
            String line = null;
            int iline = 1;
            try {
                while ((line = bfr.readLine()) != null) {
                    lines.add(line.trim());
                    ++iline;
                }
            }
            catch (IOException ex) {
                this.error("Error loading parameters from file " + file + " at line " + iline + " " + line, ex);
            }
        }
        catch (FileNotFoundException ex) {
            this.error("Could not fing Osmose configuration file: " + file, ex);
        }
        return lines;
    }

    protected Configuration getConfiguration() {
        return Osmose.getInstance().getConfiguration();
    }

    protected String backup(String src) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(System.currentTimeMillis());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        formatter.setCalendar(calendar);
        StringBuilder bak = new StringBuilder(src);
        bak.append(".bak");
        bak.append(formatter.format(calendar.getTime()));
        if (!new File(bak.toString()).exists()) {
            try {
                this.copyFile(new File(src), new File(bak.toString()));
                return bak.toString();
            }
            catch (IOException ex) {
                this.error("Failed to backup configuration file " + src, ex);
            }
        }
        return null;
    }

    private void copyFile(File src, File dest) throws IOException {
        FileInputStream fis = new FileInputStream(src);
        FileOutputStream fos = new FileOutputStream(dest);
        FileChannel channelSrc = fis.getChannel();
        FileChannel channelDest = fos.getChannel();
        channelSrc.transferTo(0L, channelSrc.size(), channelDest);
        fis.close();
        fos.close();
    }
}

