/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.util.timeseries;

import au.com.bytecode.opencsv.CSVReader;
import fr.ird.osmose.util.Separator;
import fr.ird.osmose.util.SimulationLinker;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public class ByClassTimeSeries
extends SimulationLinker {
    private float[] classes;
    private double[][] values;

    public ByClassTimeSeries(int rank) {
        super(rank);
    }

    public void read(String filename) {
        int nStepYear = this.getConfiguration().getNStepYear();
        int nStepSimu = nStepYear * this.getConfiguration().getNYear();
        this.read(filename, nStepYear, nStepSimu);
    }

    public void read(String filename, int nMin, int nMax) {
        int nStepYear = this.getConfiguration().getNStepYear();
        int nStepSimu = nStepYear * this.getConfiguration().getNYear();
        try {
            int t;
            CSVReader reader = new CSVReader(new FileReader(filename), Separator.guess(filename).getSeparator());
            List<String[]> lines = reader.readAll();
            String[] lineThreshold = lines.get(0);
            this.classes = new float[lineThreshold.length - 1];
            for (int k = 0; k < this.classes.length; ++k) {
                this.classes[k] = Float.valueOf(lineThreshold[k + 1]).floatValue();
            }
            int nTimeSerie = lines.size() - 1;
            if (nTimeSerie < nMin) {
                throw new IOException("Found " + nTimeSerie + " time steps in the time serie. It must contain at least " + nMin + " time steps.");
            }
            if (nTimeSerie % nStepYear != 0) {
                throw new IOException("Found " + nTimeSerie + " time steps in the time serie. It must be a multiple of the number of time steps per year.");
            }
            if (nTimeSerie > nMax) {
                this.getSimulation().warning("Time serie in file {0} contains {1} steps out of {2}. Osmose will ignore the exceeding years.", new Object[]{filename, nTimeSerie, nMax});
            }
            nTimeSerie = Math.min(nTimeSerie, nMax);
            this.values = new double[nStepSimu][];
            for (t = 0; t < nTimeSerie; ++t) {
                this.values[t] = new double[lineThreshold.length - 1];
                String[] fval = lines.get(t + 1);
                for (int k = 0; k < this.values[t].length; ++k) {
                    this.values[t][k] = Double.valueOf(fval[k + 1]);
                }
            }
            if (nTimeSerie < nStepSimu) {
                t = nTimeSerie;
                block5: while (t < nStepSimu) {
                    for (int k = 0; k < nTimeSerie; ++k) {
                        this.values[t] = this.values[k];
                        if (++t == nStepSimu) continue block5;
                    }
                }
                this.getSimulation().warning("Time serie in file {0} only contains {1} steps out of {2}. Osmose will loop over it.", new Object[]{filename, nTimeSerie, nStepSimu});
            }
        }
        catch (IOException ex) {
            this.getSimulation().error("Error reading CSV file " + filename, ex);
        }
    }

    public int classOf(float school) {
        if (school < this.classes[0]) {
            return -1;
        }
        for (int k = 0; k < this.classes.length - 1; ++k) {
            if (!(this.classes[k] <= school) || !(school < this.classes[k + 1])) continue;
            return k;
        }
        return this.classes.length - 1;
    }

    public double getValue(int step, float school) {
        return this.values[step][this.classOf(school)];
    }

    public int getNClass() {
        return this.classes.length;
    }

    public float getClass(int k) {
        return this.classes[k];
    }

    public float[] getClasses() {
        return this.classes;
    }

    public double[][] getValues() {
        return this.values;
    }
}

