/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process.mortality;

import fr.ird.osmose.Prey;
import fr.ird.osmose.School;
import fr.ird.osmose.process.AbstractProcess;
import fr.ird.osmose.process.mortality.IterativeMortalityProcess;
import fr.ird.osmose.process.mortality.MortalityCause;
import fr.ird.osmose.process.mortality.OutMortality;
import fr.ird.osmose.process.mortality.StarvationMortality;
import fr.ird.osmose.process.mortality.StochasticMortalityProcess;
import java.util.Collection;

public class MortalityProcess
extends AbstractProcess {
    private AbstractProcess insideMortalityProcess;
    private OutMortality outsideMortalityProcess;
    private StarvationMortality starvationMortality;

    public MortalityProcess(int rank) {
        super(rank);
    }

    @Override
    public void init() {
        MortalityAlgorithm mortalityAlgorithm;
        try {
            mortalityAlgorithm = MortalityAlgorithm.valueOf(this.getConfiguration().getString("mortality.algorithm").toUpperCase());
        }
        catch (Exception ex) {
            mortalityAlgorithm = MortalityAlgorithm.STOCHASTIC;
        }
        this.info("Mortality algorithm set to " + mortalityAlgorithm.toString());
        switch (mortalityAlgorithm) {
            case ITERATIVE: {
                this.insideMortalityProcess = new IterativeMortalityProcess(this.getRank());
                break;
            }
            case STOCHASTIC: {
                this.insideMortalityProcess = new StochasticMortalityProcess(this.getRank());
            }
        }
        this.insideMortalityProcess.init();
        this.outsideMortalityProcess = new OutMortality(this.getRank());
        this.outsideMortalityProcess.init();
        this.starvationMortality = new StarvationMortality(this.getRank());
        this.starvationMortality.init();
    }

    @Override
    public void run() {
        this.insideMortalityProcess.run();
        for (School school : this.getSchoolSet()) {
            Collection<Prey> preys;
            school.setStarvationRate(this.starvationMortality.getRate(school));
            if (!(school.getPreyedBiomass() > 0.0) || (preys = school.getPreys()).isEmpty()) continue;
            double trophicLevel = 0.0;
            for (Prey prey : preys) {
                trophicLevel += (double)prey.getTrophicLevel() * prey.getBiomass() / school.getPreyedBiomass();
            }
            school.setTrophicLevel((float)(trophicLevel += 1.0));
        }
        for (School school : this.getSchoolSet().getOutSchools()) {
            double nDead = school.getInstantaneousAbundance() * (1.0 - Math.exp(-this.outsideMortalityProcess.getRate(school)));
            if (!(nDead > 0.0)) continue;
            school.setNdead(MortalityCause.OUT, nDead);
        }
    }

    private static enum MortalityAlgorithm {
        ITERATIVE,
        STOCHASTIC;

    }
}

