/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose;

import fr.ird.osmose.Cell;
import fr.ird.osmose.IAggregation;
import fr.ird.osmose.Osmose;
import fr.ird.osmose.Plankton;
import fr.ird.osmose.process.mortality.MortalityCause;

public class Swarm
implements IAggregation {
    private final Plankton plankton;
    private final Cell cell;
    private final int index;
    private double abundance;
    private double nDead;

    public Swarm(Plankton plankton, Cell cell) {
        this.plankton = plankton;
        this.cell = cell;
        this.index = plankton.getIndex() + Osmose.getInstance().getConfiguration().getNSpecies();
    }

    @Override
    public double getAbundance() {
        return this.abundance;
    }

    @Override
    public double getInstantaneousAbundance() {
        return Math.max(0.0, this.abundance - this.nDead);
    }

    public void updateBiomass(int iStepSimu) {
        this.abundance = this.plankton.getAccessibleBiomass(this.cell, iStepSimu);
        this.nDead = 0.0;
    }

    @Override
    public double getBiomass() {
        return this.abundance;
    }

    @Override
    public double getInstantaneousBiomass() {
        return this.getInstantaneousAbundance();
    }

    @Override
    public void incrementNdead(MortalityCause cause, double nDead) {
        if (cause != MortalityCause.PREDATION) {
            throw new UnsupportedOperationException("MortalityCause for Swarm must be PREDATION only.");
        }
        this.nDead += nDead;
    }

    @Override
    public double biom2abd(double biomass) {
        return biomass;
    }

    @Override
    public int getSpeciesIndex() {
        return this.index;
    }

    @Override
    public float getAge() {
        return Float.NaN;
    }

    @Override
    public float getLength() {
        return Float.NaN;
    }

    @Override
    public float getTrophicLevel() {
        return this.plankton.getTrophicLevel();
    }

    @Override
    public float getWeight() {
        return 1.0f;
    }
}

