/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose;

import fr.ird.osmose.Configuration;
import fr.ird.osmose.Osmose;

public class Species {
    public static final float TL_EGG = 3.0f;
    private final int index;
    private final String name;
    private final int lifespan;
    private final float lInf;
    private final float K;
    private final float t0;
    private final float c;
    private final float bPower;
    private final float sizeMaturity;
    private final int ageClassZero;
    private final float eggSize;
    private final float eggWeight;
    private final float growthAgeThreshold;

    public Species(int index) {
        this.index = index;
        this.name = this.getConfiguration().getString("species.name.sp" + index);
        this.lInf = this.getConfiguration().getFloat("species.linf.sp" + index);
        this.K = this.getConfiguration().getFloat("species.k.sp" + index);
        this.t0 = this.getConfiguration().getFloat("species.t0.sp" + index);
        this.c = this.getConfiguration().getFloat("species.length2weight.condition.factor.sp" + index);
        this.bPower = this.getConfiguration().getFloat("species.length2weight.allometric.power.sp" + index);
        if (!this.getConfiguration().isNull("species.maturity.size.sp" + index)) {
            this.sizeMaturity = this.getConfiguration().getFloat("species.maturity.size.sp" + index);
        } else {
            float ageMaturity = this.getConfiguration().getFloat("species.maturity.age.sp" + index);
            this.sizeMaturity = this.lInf * (float)(1.0 - Math.exp(-this.K * (ageMaturity - this.t0)));
        }
        float age0 = this.getConfiguration().getFloat("output.cutoff.age.sp" + index);
        this.ageClassZero = (int)Math.ceil(age0 * (float)this.getConfiguration().getNStepYear());
        this.eggSize = this.getConfiguration().getFloat("species.egg.size.sp" + index);
        this.eggWeight = this.getConfiguration().getFloat("species.egg.weight.sp" + index);
        this.growthAgeThreshold = !this.getConfiguration().isNull("species.vonbertalanffy.threshold.age.sp" + index) ? this.getConfiguration().getFloat("species.vonbertalanffy.threshold.age.sp" + index) : 1.0f;
        float agemax = this.getConfiguration().getFloat("species.lifespan.sp" + index);
        this.lifespan = Math.round(agemax * (float)this.getConfiguration().getNStepYear());
    }

    public float computeMeanLength(int age) {
        float length;
        float decimalAge = (float)age / (float)this.getConfiguration().getNStepYear();
        if (age == 0) {
            length = this.eggSize;
        } else if (decimalAge < this.growthAgeThreshold) {
            float lengthAtAgePart = (float)((double)this.lInf * (1.0 - Math.exp(-this.K * (this.growthAgeThreshold - this.t0))));
            if (lengthAtAgePart < this.eggSize) {
                lengthAtAgePart = this.eggSize;
            }
            length = decimalAge / this.growthAgeThreshold * (lengthAtAgePart - this.eggSize) + this.eggSize;
        } else {
            length = (float)((double)this.lInf * (1.0 - Math.exp(-this.K * (decimalAge - this.t0))));
        }
        return length;
    }

    public int computeMeanAge(float length) {
        float lengthAtAgePart = (float)((double)this.lInf * (1.0 - Math.exp(-this.K * (this.growthAgeThreshold - this.t0))));
        float age = length > lengthAtAgePart ? (length < this.lInf ? (float)(-(Math.log(1.0f - length / this.lInf) / (double)this.K)) + this.t0 : (float)this.lifespan) : this.growthAgeThreshold * (length - this.eggSize) / (lengthAtAgePart - this.eggSize);
        return Math.round(age * (float)this.getConfiguration().getNStepYear());
    }

    public float computeMeanWeight(int age) {
        float weight;
        if (age == 0) {
            weight = this.eggWeight;
        } else {
            weight = this.computeWeight(this.computeMeanLength(age));
            if (weight < this.eggWeight) {
                weight = this.eggWeight;
            }
        }
        return weight;
    }

    public float computeWeight(float length) {
        return (float)((double)this.c * Math.pow(length, this.bPower));
    }

    public int getLifespanDt() {
        return this.lifespan;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public float getEggSize() {
        return this.eggSize;
    }

    public float getEggWeight() {
        return this.eggWeight;
    }

    public int getAgeClassZero() {
        return this.ageClassZero;
    }

    public float getSizeMaturity() {
        return this.sizeMaturity;
    }

    private boolean isVulnerable(double biomass) {
        double Bv = 0.0;
        double Sv = 1.0;
        return Math.random() > 1.0 / (1.0 + Math.exp(Sv * (Bv - biomass)));
    }

    private Configuration getConfiguration() {
        return Osmose.getInstance().getConfiguration();
    }
}

