% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{oe_match_pattern}
\alias{oe_match_pattern}
\title{Check patterns in the provider's databases}
\usage{
oe_match_pattern(
  pattern,
  provider = "geofabrik",
  match_by = "name",
  full_row = FALSE
)
}
\arguments{
\item{pattern}{Character string representing the pattern that should be
explored.}

\item{provider}{Which provider should be used? Check a summary of all
available providers with \code{\link[=oe_providers]{oe_providers()}}.}

\item{match_by}{Column name of the provider's database that will be used to
find the match.}

\item{full_row}{Boolean. Return all columns for the matching rows? \code{FALSE} by
default.}
}
\value{
A character vector or a subset of the provider's database.
}
\description{
This function is used to explore the provider's databases and look for
patterns. This function can be useful in combination with \code{\link[=oe_match]{oe_match()}} and
\code{\link[=oe_get]{oe_get()}} for an easy match. See Examples.
}
\examples{
\dontrun{
oe_match("Yorkshire", quiet = FALSE)}
oe_match_pattern("Yorkshire")

res = oe_match_pattern("Yorkshire", full_row = TRUE)
sf::st_drop_geometry(res)[1:3]
}
