% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps_api.R
\name{query_maps}
\alias{query_maps}
\alias{query_maps.qExtent}
\title{Query the OS Maps API}
\usage{
query_maps(
  x,
  layer = c("Road_27700", "Road_3857", "Outdoor_27700", "Outdoor_3857", "Light_27700",
    "Light_3857", "Leisure_27700"),
  zoom,
  output_dir,
  overwrite = FALSE,
  key = get_os_key(),
  ...
)

\method{query_maps}{qExtent}(
  x,
  layer = c("Road_27700", "Road_3857", "Outdoor_27700", "Outdoor_3857", "Light_27700",
    "Light_3857", "Leisure_27700"),
  zoom,
  output_dir,
  overwrite = FALSE,
  key = get_os_key(),
  ...
)
}
\arguments{
\item{x}{Object defining the query extent. Should be of type \code{qExtent}
created by the \code{extent_from_*} functions.}

\item{layer}{(character) The name of the layer to query. See details.}

\item{zoom}{(numeric) The zoom level of the tiles to return. If omitted, a
suitable zoom level will be estimated. See details.}

\item{output_dir}{(character) Path to the directory where the downloaded
tiles will be saved.}

\item{overwrite}{Boolean. Should existing files be overwritten? Default is
\code{FALSE}.}

\item{key}{(character) OS API key. Default action is to search for an
environment variable using \code{get_os_key()}.}

\item{...}{Additional parameters (not currently used).}
}
\value{
A list of file paths to the downloaded image tiles, their bounding
boxes, and coordinate reference system information.
}
\description{
Retrieve pre-rendered tiles from the web maps service of the Maps API in the
Ordnance Survey Data Hub.
}
\details{
The OS Maps API serves pre-rendered raster tiles and is available in
two projections; British National Grid and Web Mercator. This function
provides basic access to download these tiles to your local machine.

Alternatively, you can request the maps using the Open Geospatial
Consortium Web Map Tile Service (WMTS) standard or RESTful ZXY for easy
access/visualisation in most GIS software and web mapping applications.
More information on the Maps API is available from:
\url{https://osdatahub.os.uk/docs/wmts/technicalSpecification}.

The parameter \code{x} currently only accepts a query extent created from
\code{extent_from_*} family of functions. The coordinate reference system
of this extent must match the coordinate reference system of the returned
tiles (i.e. only EPSG:27700 and EPSG:3857 are accepted).

The available layers are Road, Outdoor, Light in both 27700 and 3857, plus
Leisure in 27700. These should be specified as combined strings to the
\code{layer} argument, e.g. 'Road_27700'.

The zoom levels available vary based on the projection of the tile matrix
set. EPSG:3857 is from 7 to 20 and EPSG:27700 is from 0 to 13. See the
technical specifications for more information on the scale and resolution:
\url{https://osdatahub.os.uk/docs/wmts/technicalSpecification}
}
\examples{
\dontshow{if (has_os_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Define an extent.
OS_ext <- extent_from_bng('SU3715')

# Download tiles.
imgTile <- query_maps(OS_ext,
                      layer = 'Light_27700',
                      output_dir = tempdir())

# The tiles can be merged together and georeferenced for spatial applications.
\dontshow{\}) # examplesIf}
}
\seealso{
\link{extent}
}
