chebyshev.c.polynomials <- function( n, normalized=FALSE )
{
###
### This function returns a list with n+1 elements
### containing the order k Chebyshev polynomials of the first kind, Ck(x),
### for orders k=0,1,...n
###
### Parameters
### n = integer highest polynomial order
### normalized = boolean value.  if true, the polynomials are normalized
###
    require( polynom )
    recurrences <- chebyshev.c.recurrences( n, normalized )
    np1 <- nrow( recurrences )
    n <- np1 - 1
    c <- recurrences$c
    d <- recurrences$d
    e <- recurrences$e
    f <- recurrences$f
    polynomials <- as.list( rep( NULL, np1 ) )
    p.0 <- polynomial( c( 2 ) )
    polynomials[[1]] <- p.0
    j <- 0
    while ( j < n ) {
        cj <- c[j+1]
        dj <- d[j+1]
        ej <- e[j+1]
        fj <- f[j+1]
        monomial <- polynomial( c( dj, ej ) )
        if ( j == 0 ) {
            p.jp1 <- ( monomial * p.0 ) / cj
        }
        else {
            p.jm1 <- polynomials[[j]]
            p.j   <- polynomials[[j+1]]
            p.jp1 <- ( monomial * p.j - fj * p.jm1 ) / cj
        }
        polynomials[[j+2]] <- p.jp1
        j <- j + 1
    }
    if ( normalized ) {
        norms <- sqrt( chebyshev.c.inner.products( n ) )
        for ( k in 1:np1 ) {
            polynomials[[k]] <- polynomials[[k]] / norms[k]
        }
    }
    return( polynomials )
}
