% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{matches}
\alias{groups}
\alias{groups.default}
\alias{groups.list}
\alias{groups.orearg}
\alias{groups.orematch}
\alias{matches}
\alias{matches.default}
\alias{matches.list}
\alias{matches.orematch}
\title{Extract matching substrings}
\usage{
matches(object, ...)

\method{matches}{list}(object, simplify = TRUE, ...)

\method{matches}{orematch}(object, ...)

\method{matches}{default}(object, ...)

groups(object, ...)

\method{groups}{list}(object, simplify = TRUE, ...)

\method{groups}{orematch}(object, ...)

\method{groups}{orearg}(object, ...)

\method{groups}{default}(object, ...)
}
\arguments{
\item{object}{An R object. Methods are provided for generic lists and
\code{"orematch"} objects.}

\item{...}{Further arguments to methods.}

\item{simplify}{For the list methods, should nonmatching elements be removed
from the result?}
}
\value{
A vector, matrix, array, or list of the same, containing full
  matches or subgroups. If \code{simplify} is \code{TRUE}, the result may
  have a \code{dropped} attribute, giving the indices of nonmatching
  elements.
}
\description{
These functions extract entire matches, or just subgroup matches, from
objects of class \code{"orematch"}. They can also be applied to lists of
these objects, as returned by \code{\link{ore.search}} when more than one
string is searched. For other objects they return \code{NA}.
}
\seealso{
\code{\link{ore.search}}
}

