% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-base-svd.r
\name{methods-svd}
\alias{methods-svd}
\alias{as_tbl_ord.svd_ord}
\alias{recover_rows.svd_ord}
\alias{recover_cols.svd_ord}
\alias{recover_inertia.svd_ord}
\alias{recover_coord.svd_ord}
\alias{recover_conference.svd_ord}
\alias{recover_aug_rows.svd_ord}
\alias{recover_aug_cols.svd_ord}
\alias{recover_aug_coord.svd_ord}
\title{Functionality for singular value decompositions}
\usage{
\method{as_tbl_ord}{svd_ord}(x)

\method{recover_rows}{svd_ord}(x)

\method{recover_cols}{svd_ord}(x)

\method{recover_inertia}{svd_ord}(x)

\method{recover_coord}{svd_ord}(x)

\method{recover_conference}{svd_ord}(x)

\method{recover_aug_rows}{svd_ord}(x)

\method{recover_aug_cols}{svd_ord}(x)

\method{recover_aug_coord}{svd_ord}(x)
}
\arguments{
\item{x}{An ordination object.}
}
\value{
The recovery generics \verb{recover_*()} return \link[=recoverers]{core model components}, \link[=conference]{distribution of inertia},
\link[=supplementation]{supplementary elements}, and \link[=augmentation]{intrinsic metadata}; but they require methods for each model class to
tell them what these components are.

The generic \code{\link[=as_tbl_ord]{as_tbl_ord()}} returns its input wrapped in the 'tbl_ord'
class. Its methods determine what model classes it is allowed to wrap. It
then provides 'tbl_ord' methods with access to the recoverers and hence to
the model components.
}
\description{
These methods extract data from, and attribute new data to,
objects of class \code{"svd_ord"} returned by \code{\link[=svd_ord]{svd_ord()}}.
}
\examples{
# matrix of U.S. personal expenditure data
class(USPersonalExpenditure)
print(USPersonalExpenditure)
# singular value decomposition into row and column coordinates
USPersonalExpenditure \%>\%
  svd_ord() \%>\%
  as_tbl_ord() \%>\%
  print() -> spend_svd

# recover matrices of row and column coordinates
get_rows(spend_svd)
get_cols(spend_svd)

# augment with row and column names
augment_ord(spend_svd)
# initial matrix decomposition confers no inertia to coordinates
get_conference(spend_svd)
}
\seealso{
Other methods for singular value decomposition-based techniques: 
\code{\link{methods-cancor}},
\code{\link{methods-correspondence}},
\code{\link{methods-lda}},
\code{\link{methods-lra}},
\code{\link{methods-mca}},
\code{\link{methods-prcomp}},
\code{\link{methods-princomp}}
}
\concept{methods for singular value decomposition-based techniques}
