% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-tidiers.r
\name{list_tidiers}
\alias{list_tidiers}
\alias{tidy.list}
\alias{glance.list}
\title{Tidying methods for (additional) lists}
\usage{
\method{tidy}{list}(x, ...)

\method{glance}{list}(x, ...)
}
\arguments{
\item{x}{A list, potentially representing an object that can be tidied.}

\item{...}{Additionally, arguments passed to the tidying function.}
}
\value{
A \link[tibble:tibble]{tibble}.
}
\description{
Some unclassed lists of fixed structure, returned by other
functions, are recognized by \strong{broom}'s \link[broom:list_tidiers]{list tidiers}. \strong{ordr}'s updated list tidiers append
additional checks for the list structures returned by \code{\link[=cmdscale]{cmdscale()}} and
\code{\link[=cancor]{cancor()}}. If such structure is detected, then the new in-package tidiers
are called.
}
\seealso{
\code{\link[generics:tidy]{generics::tidy()}} \code{\link[generics:glance]{generics::glance()}}

Other list tidiers: 
\code{\link{cancor_tidiers}},
\code{\link{cmdscale_tidiers}}
}
\concept{list tidiers}
