% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ordinalNet.R
\name{coef.ordinalNetFit}
\alias{coef.ordinalNetFit}
\title{Extracts fitted coefficients from an "ordinalNetFit" object.}
\usage{
\method{coef}{ordinalNetFit}(object, whichLambda = NULL, criteria = c("aic",
  "bic"), ...)
}
\arguments{
\item{object}{An "ordinalNetFit" S3 object.}

\item{whichLambda}{Optional index number(s) of the desired \code{lambda} within
the sequence of \code{lambdaVals}.
\code{whichLambda=1:nLambda} will return the entire solution path.}

\item{criteria}{Selects the best \code{lambda} value by AIC or BIC. Only used
if \code{whichLambda=NULL}.}

\item{...}{Not used. Additional coef arguments.}
}
\value{
Vector of fitted coefficients.
}
\description{
Extracts fitted coefficients from an "ordinalNetFit" object.
}
\examples{
set.seed(10)
x <- matrix(rnorm(50*5), ncol=5)
beta <- c(1, 0, 0, 0, 0)
intercepts <- c(-1, 1)
xb <- x \%*\% beta
eta <- cbind(xb+intercepts[1], xb+intercepts[2])
probMatCumul <- 1 / (1 + exp(-eta))
probMat <- cbind(probMatCumul, 1) - cbind(0, probMatCumul)
y <- apply(probMat, 1, function(p) sample(1:3, size=1, prob=p))
y <- as.factor(y)
fit <- ordinalNet(x, y)
coef(fit)
}

