% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{orderly_list}
\alias{orderly_list}
\title{List orderly reports}
\usage{
orderly_list(root = NULL, locate = TRUE)
}
\arguments{
\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}
}
\value{
A character vector of report names
}
\description{
List the \emph{names} of reports known to orderly.  These are the
\emph{source} names, not the results of running reports.  Note
that if a report has been committed from a different branch it
will not appear here, as this is simply the set of reports in the
\code{src} directory that can be run.
}
\examples{
# The orderly demo, with lots of potential reports:
path <- orderly::orderly_example("demo")

# Reports that _could_ be run:
orderly::orderly_list(path)
}
\seealso{
\code{\link[=orderly_list_archive]{orderly_list_archive()}} and
\code{\link[=orderly_list_drafts]{orderly_list_drafts()}}, which list archived
(committed) and draft reports and their versions.
}
