% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe_run.R
\name{orderly_run}
\alias{orderly_run}
\title{Run a report}
\usage{
orderly_run(name, parameters = NULL, envir = NULL, root = NULL,
  locate = TRUE, echo = TRUE, id_file = NULL, fetch = FALSE,
  ref = NULL, message = NULL)
}
\arguments{
\item{name}{Name of the report to run (see
\code{\link{orderly_list}}).}

\item{parameters}{Parameters passed to the report. A named list of
parameters declared in the \code{orderly.yml}.}

\item{envir}{The parent of the environment that will be used to
evaluate the report script; by default a new environment will be
made with the global environment as the parent.}

\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}

\item{echo}{Print the result of running the R code to the console}

\item{id_file}{Write the identifier into a file}

\item{fetch}{Logical, indicating if git should be fetched before
checking out the reference \code{ref}.}

\item{ref}{A git reference to use for this run (see Details)}

\item{message}{An optional character string containing a message
explaining why the report was run}
}
\value{
The id of the newly created report
}
\description{
Run a report.  This will create a new directory in
\code{drafts/<reportname>}, copy your declared resources there,
extract data from databases (if you are using them), run your
script and check that all expected artefacts were created.  Once
successfully run you can use \code{\link{orderly_commit}} to move
it to the \code{archive} directory.
}
\details{
If \code{ref} is provided then before running a report orderly
will try to check out (as a detached \code{HEAD}) \code{ref},
interpreted as a git reference.  This can be a commit, tag, or a
branch name (including remote).  The working directory must be
clean according to \code{git status} and this \emph{will} require
some careful use of \code{.gitignore} to exclude \code{draft},
\code{archive}, \code{data} and \code{orderly.sqlite}.  The git
tree will revert back to the original branch at completion (or
failure to complete) the report.

Parameters are passed to the report as a named list, for example

\code{
id <- orderly::orderly_run("other", list(nmin = 0.2), root = path)
}

(see the examples).  The names of the parameters (here,
\code{nmin}) must correspond to declared parameters in the
\code{orderly.yml}.  It is an error if parameters without a
default are omitted, and it is an error if unknown parameters are
provided.
}
\examples{
path <- orderly::orderly_example("demo")

# To run most reports, provide the report name (and the path if
# not running in the working directory, as is the case here):
id <- orderly::orderly_run("minimal", root = path)

# Every report gets a unique identifier, based on the time (it is
# ISO 8601 time with random hex appended to end)
id

# After being run, a report is a "draft" and will exist in the
# drafts directory:
orderly::orderly_list_drafts(root = path)

# Draft reports are always stored in the path
# <root>/draft/<name>/<id>, so we have
dir(file.path(path, "draft", "minimal", id))

# which contains the files when the report was run.

# If a report has parameters, then these must be passed in as a
# named list.
id <- orderly::orderly_run("other", list(nmin = 0.2), root = path)

# These parameters can be used in SQL queries or in the report
# code.
}
\seealso{
\code{\link{orderly_log}} for controlling display of log
  messages (not just R output)
}
