% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_funs.R
\name{inv_vb}
\alias{inv_vb}
\title{The inverse von Bertalanffy function (iVBGF)}
\usage{
inv_vb(len, linf, k, t0)
}
\arguments{
\item{len}{Numeric. A length at which to determine how long it takes to grow}

\item{linf}{The \ifelse{html}{\out{L<sub>&infin;</sub>}}{\eqn{L_\infty}}
parameter of the VBGF}

\item{k}{The k parameter of the VBGF}

\item{t0}{The \ifelse{html}{\out{t<sub>0</sub>}}{\eqn{t_0}}}
}
\value{
A numeric vector of how long it takes to grow to length \code{len}
}
\description{
This function calculates the inverse of the VBGF, or, time it takes to grow
to a particular length
}
\examples{
time <- 365
len_at_age <- vbgf(time, 30, (0.2 / 365), -0.2)
inv_vb(len_at_age, 30, (0.2/365), -0.2)
}
