% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficient_round.R
\name{efficient_round}
\alias{efficient_round}
\title{Efficient Round}
\usage{
efficient_round(design, n, tol = 1e-05)
}
\arguments{
\item{design}{a dataframe with columns "Point" and "Weight" that represents a design}

\item{n}{an integer that represents the desired number of observations of the exact design}

\item{tol}{optional parameter for the consideration of an integer in the rounding process}
}
\value{
a data.frame with columns "Point" and "Weight" representing an exact design
with n observations
}
\description{
Takes an approximate design, and a number of points and converts the design to
an approximate design. It uses the multiplier (n - l/2) and evens the total
number of observations afterwards.
}
\examples{
design_test <- data.frame("Point" = seq(1, 5, length.out = 7),
         "Weight" = c(0.1, 0.0001, 0.2, 0.134, 0.073, 0.2111, 0.2818))

efficient_round(design_test, 20)

exact_design <- efficient_round(design_test, 21)
aprox_design <- exact_design
aprox_design$Weight <- aprox_design$Weight/sum(aprox_design$Weight)
}
