% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_manual_targets.R
\docType{methods}
\name{add_manual_targets}
\alias{add_manual_targets}
\alias{add_manual_targets-method}
\alias{add_manual_targets,ProjectProblem,data.frame-method}
\alias{add_manual_targets,ProjectProblem,tbl_df-method}
\title{Add manual targets}
\usage{
\S4method{add_manual_targets}{ProjectProblem,data.frame}(x, targets)

\S4method{add_manual_targets}{ProjectProblem,tbl_df}(x, targets)
}
\arguments{
\item{x}{\code{\link{ProjectProblem-class}} object.}

\item{targets}{\code{data.frame} or \code{\link[tibble]{tibble}} object. See
the Details section for more information.}
}
\value{
\code{\link{ProjectProblem-class}} object with the targets added
  to it.
}
\description{
Set targets for a project prioritization \code{\link{problem}} by manually
specifying all the required information for each target. This function
is useful because it can be used to customize all aspects of a target. For
most cases, targets can be specified using the
\code{\link{add_absolute_targets}} and \code{\link{add_relative_targets}}
functions. However, this function can be used to mix absolute and
relative targets for different features.
}
\details{
Targets are used to specify the minimum probability of persistence
  for each feature in solutions. For minimum set objectives
  (i.e. \code{\link{add_min_set_objective}}, these targets
  specify the minimum probability of persistence required for each species
  in the solution. And for budget constrained objectives that use targets
  (i.e. \code{\link{add_max_targets_met_objective}}), these targets
  specify the minimum threshold probability of persistence that needs to be
  achieved to count the benefits for conserving these species.
  Please note that attempting to solve problems with objectives that require
  targets without specifying targets will throw an error.

  The \code{targets} argument should contain the following columns:

  \describe{

  \item{\code{"feature"}}{\code{character} name of features in argument
    to \code{x}.}

  \item{\code{"type"}}{\code{character} describing the type of target.
    Acceptable values include \code{"absolute"} and \code{"relative"}.
    These values correspond to \code{\link{add_absolute_targets}},
    and \code{\link{add_relative_targets}} respectively.}

  \item{\code{"sense"}}{\code{character} sense of the target. The
    only acceptable value currently supported is: \code{">="}. This field
    (column) is optional and if it is missing then target senses will
    default to \code{">="} values.}

  \item{\code{"target"}}{\code{numeric} target threshold.}

  }
}
\examples{
# load data
data(sim_projects, sim_features, sim_actions)


# create data frame with targets
targets <- data.frame(feature = sim_features$name,
                      type = "absolute",
                      target = 0.1)

# print targets
print(targets)

# build problem with minimum set objective and targets that require each
# feature to have a 30\% chance of persisting into the future
p <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
      add_min_set_objective() \%>\%
      add_manual_targets(targets) \%>\%
      add_binary_decisions()

# print problem
print(p)

\donttest{
# solve problem
s <- solve(p)

# print solution
print(s)
}
}
\seealso{
\code{\link{targets}}.
}
