% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_styles.R
\name{create_cell_style}
\alias{create_cell_style}
\title{Helper to create a cell style}
\usage{
create_cell_style(
  border_id = "",
  fill_id = "",
  font_id = "",
  num_fmt_id = "",
  pivot_button = "",
  quote_prefix = "",
  xf_id = "",
  horizontal = "",
  indent = "",
  justify_last_line = "",
  reading_order = "",
  relative_indent = "",
  shrink_to_fit = "",
  text_rotation = "",
  vertical = "",
  wrap_text = "",
  ext_lst = "",
  hidden = "",
  locked = "",
  ...
)
}
\arguments{
\item{border_id}{dummy}

\item{fill_id}{dummy}

\item{font_id}{dummy}

\item{num_fmt_id}{a numFmt ID for a builtin style}

\item{pivot_button}{dummy}

\item{quote_prefix}{dummy}

\item{xf_id}{dummy}

\item{horizontal}{alignment can be '', 'general', 'left', 'center', 'right', 'fill', 'justify', 'centerContinuous', 'distributed'}

\item{indent}{dummy}

\item{justify_last_line}{dummy}

\item{reading_order}{dummy}

\item{relative_indent}{dummy}

\item{shrink_to_fit}{dummy}

\item{text_rotation}{dummy}

\item{vertical}{alignment can be '', 'top', 'center', 'bottom', 'justify', 'distributed'}

\item{wrap_text}{dummy}

\item{ext_lst}{dummy}

\item{hidden}{dummy}

\item{locked}{dummy}

\item{...}{reserved for additional arguments}
}
\description{
Helper to create a cell style
}
\details{
\tabular{ll}{
   "ID" \tab "numFmt" \cr
   "0" \tab "General" \cr
   "1" \tab "0" \cr
   "2" \tab "0.00" \cr
   "3" \tab "#,##0" \cr
   "4" \tab "#,##0.00" \cr
   "9" \tab "0\%" \cr
   "10" \tab "0.00\%" \cr
   "11" \tab "0.00E+00" \cr
   "12" \tab "# ?/?" \cr
   "13" \tab "# ??/??" \cr
   "14" \tab "mm-dd-yy" \cr
   "15" \tab "d-mmm-yy" \cr
   "16" \tab "d-mmm" \cr
   "17" \tab "mmm-yy" \cr
   "18" \tab "h:mm AM/PM" \cr
   "19" \tab "h:mm:ss AM/PM" \cr
   "20" \tab "h:mm" \cr
   "21" \tab "h:mm:ss" \cr
   "22" \tab "m/d/yy h:mm" \cr
   "37" \tab "#,##0 ;(#,##0)" \cr
   "38" \tab "#,##0 ;[Red](#,##0)" \cr
   "39" \tab "#,##0.00;(#,##0.00)" \cr
   "40" \tab "#,##0.00;[Red](#,##0.00)" \cr
   "45" \tab "mm:ss" \cr
   "46" \tab "[h]:mm:ss" \cr
   "47" \tab "mmss.0" \cr
   "48" \tab "##0.0E+0" \cr
   "49" \tab "@" \cr
}
}
\seealso{
\code{\link[=wb_add_cell_style]{wb_add_cell_style()}}

Other style creating functions: 
\code{\link{create_border}()},
\code{\link{create_colors_xml}()},
\code{\link{create_dxfs_style}()},
\code{\link{create_fill}()},
\code{\link{create_font}()},
\code{\link{create_numfmt}()},
\code{\link{create_tablestyle}()}
}
\concept{style creating functions}
