% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-comment.R, R/class-workbook-wrappers.R
\name{create_comment}
\alias{create_comment}
\alias{write_comment}
\alias{remove_comment}
\alias{wb_add_comment}
\alias{wb_remove_comment}
\title{Create, write and remove comments}
\usage{
create_comment(
  text,
  author = Sys.info()[["user"]],
  style = NULL,
  visible = TRUE,
  width = 2,
  height = 4
)

write_comment(wb, sheet, col, row, comment, xy = NULL)

remove_comment(wb, sheet, col, row, gridExpand = TRUE)

wb_add_comment(
  wb,
  sheet = current_sheet(),
  col,
  row,
  dims = rowcol_to_dims(row, col),
  comment
)

wb_remove_comment(
  wb,
  sheet = current_sheet(),
  col,
  row,
  dims = rowcol_to_dims(row, col),
  gridExpand = TRUE
)
}
\arguments{
\item{text}{Comment text. Character vector.}

\item{author}{Author of comment. Character vector of length 1}

\item{style}{A Style object or list of style objects the same length as comment vector.}

\item{visible}{TRUE or FALSE. Is comment visible.}

\item{width}{Textbox integer width in number of cells}

\item{height}{Textbox integer height in number of cells}

\item{wb}{A workbook object}

\item{sheet}{A worksheet of the workbook}

\item{col}{A column to apply the comment}

\item{row}{A row to apply the comment}

\item{comment}{A comment to apply to the worksheet}

\item{xy}{An alternative to specifying \code{col} and
\code{row} individually.  A vector of the form
\code{c(col, row)}.}

\item{gridExpand}{Remove all comments inside the grid. Similar to dims "A1:B2"}

\item{dims}{Optional row and column as spreadsheet dimension, e.g. "A1"}
}
\value{
The \code{wbWorkbook} object

The \code{wbWorkbook} object
}
\description{
The comment functions (create, write and remove) allow the
modification of comments. In newer Excels they are called notes, while they
are called comments in openxml. Modification of what Excel now calls comment
(openxml calls them threadedComments) is not yet possible
}
\examples{
wb <- wb_workbook()
wb$add_worksheet("Sheet 1")

# write comment without author
c1 <- create_comment(text = "this is a comment", author = "")
write_comment(wb, 1, col = "B", row = 10, comment = c1)

# Write another comment with author information
c2 <- create_comment(text = "this is another comment", author = "Marco Polo")
write_comment(wb, 1, col = "C", row = 10, comment = c2)

# write a styled comment with system author
s1 <- create_font(b = "true", color = wb_color(hex = "FFFF0000"), sz = "12")
s2 <- create_font(color = wb_color(hex = "FF000000"), sz = "9")
c3 <- create_comment(text = c("This Part Bold red\n\n", "This part black"), style = c(s1, s2))

write_comment(wb, 1, col = 6, row = 3, comment = c3)

# remove the first comment
remove_comment(wb, 1, col = "B", row = 10)
}
