% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-smallpox.R
\docType{data}
\name{smallpox}
\alias{smallpox}
\title{Smallpox vaccine results}
\format{
A data frame with 6224 observations on the following 2 variables.
\describe{
\item{result}{Whether the person \code{died} or \code{lived}.}
\item{inoculated}{Whether the person received inoculated.}
}
}
\source{
Fenner F. 1988.  Smallpox and Its Eradication (History of
International Public Health, No. 6).  Geneva: World Health Organization.
ISBN 92-4-156110-6.
}
\usage{
smallpox
}
\description{
A sample of 6,224 individuals from the year 1721 who were exposed to
smallpox in Boston.  Some of them had received a vaccine (inoculated) while
others had not.  Doctors at the time believed that inoculation, which
involves exposing a person to the disease in a controlled form, could reduce
the likelihood of death.
}
\examples{

data(smallpox)
table(smallpox)

}
\keyword{datasets}
