% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-age_at_mar.R
\docType{data}
\name{age_at_mar}
\alias{age_at_mar}
\alias{age.at.mar}
\alias{ageAtMar}
\title{Age at first marriage of 5,534 US women.}
\format{
A data frame with 5,534 observations and 1 variable.
\describe{
  \item{age}{Age a first marriage.}
  }
}
\source{
National Survey of Family Growth, 2006-2010 cycle,
\url{https://www.cdc.gov/nchs/nsfg/nsfg_2006_2010_puf.htm}.
}
\usage{
age_at_mar
}
\description{
Age at first marriage of 5,534 US women who responded to the National Survey
of Family Growth (NSFG) conducted by the CDC in the 2006 and 2010 cycle.
}
\examples{

library(ggplot2)

ggplot(age_at_mar, mapping = aes(x = age)) +
  geom_histogram(binwidth = 3) +
  labs(x = "Age", y = "Count", title = "Age at first marriage, US Women",
       subtitle = "Source: National Survey of Family Growth Survey, 2006 - 2010")

}
\keyword{datasets}
