% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/services.R
\name{create_service}
\alias{create_service}
\title{Prepares and publishes a service on the back-end}
\usage{
create_service(
  type,
  graph,
  title = NULL,
  description = NULL,
  enabled = NULL,
  configuration = NULL,
  plan = NULL,
  budget = NULL,
  additional = NULL,
  con = NULL,
  ...
)
}
\arguments{
\item{type}{character - the OGC web service type name to be created or an object of type ServiceType obtainable through list_service_types()}

\item{graph}{A \code{\link[=Graph]{Graph()}}, a function returning a \code{\link[=ProcessNode]{ProcessNode()}} as an endpoint or the \code{\link[=ProcessNode]{ProcessNode()}}
will return the results}

\item{title}{character (optional) - a title for the service intended for visualization purposes in clients}

\item{description}{character (optional) - a short description of the service}

\item{enabled}{logical - whether or not the service is active or not}

\item{configuration}{a named list specifying the configuration parameter}

\item{plan}{character - the billing plan}

\item{budget}{numeric - the amount of credits that can be spent on this service}

\item{additional}{Additional, non-standardized service settings to send to the back-end}

\item{con}{connected and authenticated openEO client object (optional) otherwise \code{\link[=active_connection]{active_connection()}}
is used.}

\item{...}{additional parameters passed to jsonlite::toJSON() (like 'digits')}
}
\value{
Service object
}
\description{
The function will create a web service of a process graph / workflow on the connected openEO service.
}
