% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_file_content.R
\name{retrieve_file_content}
\alias{retrieve_file_content}
\title{Retrieve file content}
\usage{
retrieve_file_content(
  file_id,
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL
)
}
\arguments{
\item{file_id}{required; a length one character vector.}

\item{openai_api_key}{required; defaults to \code{Sys.getenv("OPENAI_API_KEY")}
(i.e., the value is retrieved from the \code{.Renviron} file); a length one
character vector. Specifies OpenAI API key.}

\item{openai_organization}{optional; defaults to \code{NULL}; a length one
character vector. Specifies OpenAI organization.}
}
\value{
Returns a list, an element of which contains the content of the file.
}
\description{
Returns the content of the specified file. See \href{https://beta.openai.com/docs/api-reference/files/retrieve-content}{this page} for
details. Please note that only output files are allowed to be downloaded, not
the input ones.
}
\details{
For arguments description please refer to the \href{https://beta.openai.com/docs/api-reference/files/retrieve-content}{official documentation}.
}
\seealso{
Other file functions: 
\code{\link{delete_file}()},
\code{\link{list_files}()},
\code{\link{retrieve_file}()},
\code{\link{upload_file}()}
}
\concept{file functions}
