/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import opennlp.maxent.AbstractDataIndexer;
import opennlp.maxent.ComparableEvent;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;
import opennlp.maxent.FileEventStream;

public class TwoPassDataIndexer
extends AbstractDataIndexer {
    public TwoPassDataIndexer(EventStream eventStream) throws IOException {
        this(eventStream, 0);
    }

    public TwoPassDataIndexer(EventStream eventStream, int cutoff) throws IOException {
        TObjectIntHashMap predicateIndex = new TObjectIntHashMap();
        System.out.println("Indexing events using cutoff of " + cutoff + "\n");
        System.out.print("\tComputing event counts...  ");
        try {
            File tmp = File.createTempFile("events", null);
            tmp.deleteOnExit();
            BufferedWriter osw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmp), "UTF8"));
            int numEvents = this.computeEventCounts(eventStream, osw, predicateIndex, cutoff);
            System.out.println("done. " + numEvents + " events");
            System.out.print("\tIndexing...  ");
            List eventsToCompare = this.index(numEvents, new FileEventStream(tmp), predicateIndex);
            predicateIndex = null;
            tmp.delete();
            System.out.println("done.");
            System.out.print("Sorting and merging events... ");
            this.sortAndMerge(eventsToCompare);
            System.out.println("Done indexing.");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private int computeEventCounts(EventStream eventStream, Writer eventStore, TObjectIntHashMap predicatesInOut, int cutoff) throws IOException {
        TObjectIntHashMap counter = new TObjectIntHashMap();
        int eventCount = 0;
        HashSet predicateSet = new HashSet();
        while (eventStream.hasNext()) {
            Event ev = eventStream.nextEvent();
            ++eventCount;
            eventStore.write(FileEventStream.toLine(ev));
            String[] ec = ev.getContext();
            TwoPassDataIndexer.update(ec, predicateSet, counter, cutoff);
        }
        this.predCounts = new int[predicateSet.size()];
        int index = 0;
        for (String predicate : predicateSet) {
            this.predCounts[index] = counter.get((Object)predicate);
            predicatesInOut.put((Object)predicate, index);
            ++index;
        }
        eventStore.close();
        return eventCount;
    }

    private List index(int numEvents, EventStream es, TObjectIntHashMap predicateIndex) {
        TObjectIntHashMap omap = new TObjectIntHashMap();
        int outcomeCount = 0;
        ArrayList<ComparableEvent> eventsToCompare = new ArrayList<ComparableEvent>(numEvents);
        TIntArrayList indexedContext = new TIntArrayList();
        while (es.hasNext()) {
            int ocID;
            Event ev = es.nextEvent();
            String[] econtext = ev.getContext();
            String oc = ev.getOutcome();
            if (omap.containsKey((Object)oc)) {
                ocID = omap.get((Object)oc);
            } else {
                ocID = outcomeCount++;
                omap.put((Object)oc, ocID);
            }
            int i = 0;
            while (i < econtext.length) {
                String pred = econtext[i];
                if (predicateIndex.containsKey((Object)pred)) {
                    indexedContext.add(predicateIndex.get((Object)pred));
                }
                ++i;
            }
            if (indexedContext.size() > 0) {
                ComparableEvent ce = new ComparableEvent(ocID, indexedContext.toNativeArray());
                eventsToCompare.add(ce);
            } else {
                System.err.println("Dropped event " + ev.getOutcome() + ":" + Arrays.asList(ev.getContext()));
            }
            indexedContext.resetQuick();
        }
        this.outcomeLabels = TwoPassDataIndexer.toIndexedStringArray(omap);
        this.predLabels = TwoPassDataIndexer.toIndexedStringArray(predicateIndex);
        return eventsToCompare;
    }
}

