/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.tokenize.TokenContextGenerator;

public class DefaultTokenContextGenerator
implements TokenContextGenerator {
    public static final String SPLIT = "T";
    public static final String NO_SPLIT = "F";

    public String[] getContext(String sentence, int index) {
        ArrayList<String> preds = new ArrayList<String>();
        preds.add("p=" + sentence.substring(0, index));
        preds.add("s=" + sentence.substring(index));
        if (index > 0) {
            this.addCharPreds("p1", sentence.charAt(index - 1), preds);
            if (index > 1) {
                this.addCharPreds("p2", sentence.charAt(index - 2), preds);
                preds.add("p21=" + sentence.charAt(index - 2) + sentence.charAt(index - 1));
            } else {
                preds.add("p2=bok");
            }
            preds.add("p1f1=" + sentence.charAt(index - 1) + sentence.charAt(index));
        } else {
            preds.add("p1=bok");
        }
        this.addCharPreds("f1", sentence.charAt(index), preds);
        if (index + 1 < sentence.length()) {
            this.addCharPreds("f2", sentence.charAt(index + 1), preds);
            preds.add("f12=" + sentence.charAt(index) + sentence.charAt(index + 1));
        } else {
            preds.add("f2=bok");
        }
        if (sentence.charAt(0) == '&' && sentence.charAt(sentence.length() - 1) == ';') {
            preds.add("cc");
        }
        String[] context = new String[preds.size()];
        preds.toArray(context);
        return context;
    }

    private void addCharPreds(String key, char c, List preds) {
        preds.add(key + "=" + c);
        if (Character.isLetter(c)) {
            preds.add(key + "_alpha");
            if (Character.isUpperCase(c)) {
                preds.add(key + "_caps");
            }
        } else if (Character.isDigit(c)) {
            preds.add(key + "_num");
        } else if (Character.isWhitespace(c)) {
            preds.add(key + "_ws");
        } else if (c == '.' || c == '?' || c == '!') {
            preds.add(key + "_eos");
        } else if (c == '`' || c == '\"' || c == '\'') {
            preds.add(key + "_quote");
        } else if (c == '[' || c == '{' || c == '(') {
            preds.add(key + "_lp");
        } else if (c == ']' || c == '}' || c == ')') {
            preds.add(key + "_rp");
        }
    }
}

