/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileReader;
import opennlp.maxent.BasicEventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;

public class CreateModel {
    public static boolean USE_SMOOTHING = false;
    public static double SMOOTHING_OBSERVATION = 0.1;

    public static void main(String[] args) {
        String dataFileName = new String(args[0]);
        String modelFileName = String.valueOf(dataFileName.substring(0, dataFileName.lastIndexOf(46))) + "Model.txt";
        try {
            FileReader datafr = new FileReader(new File(dataFileName));
            BasicEventStream es = new BasicEventStream(new PlainTextByLineDataStream(datafr));
            GIS.SMOOTHING_OBSERVATION = SMOOTHING_OBSERVATION;
            GISModel model = GIS.trainModel(es, USE_SMOOTHING);
            File outputFile = new File(modelFileName);
            SuffixSensitiveGISModelWriter writer = new SuffixSensitiveGISModelWriter(model, outputFile);
            writer.persist();
        }
        catch (Exception e) {
            System.out.print("Unable to create model due to exception: ");
            System.out.println(e);
        }
    }
}

