% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.session.R
\name{opal.session}
\alias{opal.session}
\title{Create the R session}
\usage{
opal.session(opal, wait = TRUE)
}
\arguments{
\item{opal}{Opal object.}

\item{wait}{Wait for R session to be operational (default is TRUE)}
}
\value{
The R session identifier.
}
\description{
Create the R session if it does not exist and returns its identifier.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.session(o)
opal.logout(o)
}
}
\seealso{
Other session functions: 
\code{\link{opal.session_delete}()},
\code{\link{opal.session_events}()},
\code{\link{opal.session_exists}()},
\code{\link{opal.session_get}()},
\code{\link{opal.session_running}()}
}
\concept{session functions}
