% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary.R
\name{dictionary.inspect}
\alias{dictionary.inspect}
\title{Inspect the dictionary of a tibble}
\usage{
dictionary.inspect(tibble, id.name = "id", warn = TRUE)
}
\arguments{
\item{tibble}{Tibble to be inspected.}

\item{id.name}{The name of the column representing the entity identifiers. Default is 'id'.}

\item{warn}{Print warning messages. Default is TRUE.}
}
\value{
TRUE if inspection is successful, FALSE otherwise.
}
\description{
Inspect the data dictionary, checking for inconsistencies. Error is raised when the identifiers
column cannot be found.
}
\examples{
\dontrun{
# prepare datasets of visits, several visits for one patient
visits <- tibble::tribble(
~id, ~patient_id, ~sex, ~visit_date,
1, 1, "M", as.Date("2020-01-01"),
2, 2, "F", as.Date("2020-01-02"),
3, 3, "M", as.Date("2020-01-03"),
4, 3, "M", as.Date("2020-01-04"))

o <- opal.login("administrator", "password", url = "https://opal-demo.obiba.org")

# save visits dataset
opal.table_save(o, visits, "RSRC", "visits", type = "Visit", force = TRUE)

# get visit and make it a dataset of patients 
patients <- opal.table_get(o, "RSRC", "visits", id.name = "id")
# set dataset IDs
patients$visit_id <- patients$id
patients$id <- patients$patient_id
patients$patient_id <- NULL
patients

# save patients dataset, there should be a warning that some variables are not repeatable
# while there are patients with multiple data lines
opal.table_save(o, patients, "RSRC", "patients", type = "Participant", force = TRUE)

opal.logout(o)
}
}
