% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.project.R
\name{opal.project_perm_add}
\alias{opal.project_perm_add}
\title{Add or update a permission on a project}
\usage{
opal.project_perm_add(
  opal,
  project,
  subject,
  type = "user",
  permission = "administrate"
)
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{Project name where the table will be located.}

\item{subject}{A vector of subject identifiers: user names or group names (depending on the type).}

\item{type}{The type of subject: user (default) or group.}

\item{permission}{The permission to apply: administrate.}
}
\description{
Add or update a permission on a project.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.project_perm_add(o, 'CNSIM', c('andrei', 'valentina'), 'user', 'administrate')
opal.project_perm(o, 'CNSIM')
opal.project_perm_delete(o, 'CNSIM', c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
