% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.file.r
\name{opal.file_mkdir_tmp}
\alias{opal.file_mkdir_tmp}
\title{Make a temporary folder}
\usage{
opal.file_mkdir_tmp(opal)
}
\arguments{
\item{opal}{Opal object.}
}
\value{
The path of the created folder.
}
\description{
Make a user personal temporary folder in the Opal file system (make sure it does not exists).
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
# make a folder
path <- opal.file_mkdir_tmp(o)
opal.logout(o)
}
}
\seealso{
Other file functions: 
\code{\link{opal.file_cp}()},
\code{\link{opal.file_download}()},
\code{\link{opal.file_ls}()},
\code{\link{opal.file_mkdir}()},
\code{\link{opal.file_mv}()},
\code{\link{opal.file_read}()},
\code{\link{opal.file_rm}()},
\code{\link{opal.file_upload}()},
\code{\link{opal.file_write}()},
\code{\link{opal.file}()}
}
\concept{file functions}
