% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.project.r
\name{opal.project_perm}
\alias{opal.project_perm}
\title{Get the permissions on a project}
\usage{
opal.project_perm(opal, project)
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{Project name.}
}
\value{
A data.frame with columns: subject, type, permission
}
\description{
Get the permissions that were applied on a project.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.project_perm_add(o, 'CNSIM', c('andrei', 'valentina'), 'user', 'administrate')
opal.project_perm(o, 'CNSIM')
opal.project_perm_delete(o, 'CNSIM', c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
