% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.file.r
\name{opal.file_mkdir}
\alias{opal.file_mkdir}
\title{Make a folder}
\usage{
opal.file_mkdir(opal, path)
}
\arguments{
\item{opal}{Opal object.}

\item{path}{Path to the new folder in the Opal file system.}
}
\description{
Make a folder in the Opal file system. Does not create ancestors, i.e. the call will fail if the 
parent folder does not exist.
}
\examples{
\donttest{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
# make a folder
opal.file_mkdir(o, '/home/administrator/test')
opal.logout(o)
}
}
\seealso{
Other file functions: 
\code{\link{opal.file_cp}()},
\code{\link{opal.file_download}()},
\code{\link{opal.file_ls}()},
\code{\link{opal.file_mv}()},
\code{\link{opal.file_read}()},
\code{\link{opal.file_rm}()},
\code{\link{opal.file_upload}()},
\code{\link{opal.file_write}()},
\code{\link{opal.file}()}
}
\concept{file functions}
