% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sets.R
\name{get_term_descendancy_matrix}
\alias{get_term_descendancy_matrix}
\title{Get logical descendancy matrix for set of terms}
\usage{
get_term_descendancy_matrix(ontology, terms = NULL, rows = terms,
  cols = terms)
}
\arguments{
\item{ontology}{\code{ontology_index} object.}

\item{terms}{Character vector of ontological terms.}

\item{rows}{Rows for resultant matrix (defaults to \code{terms}).}

\item{cols}{Cols for resultant matrix (defaults to \code{terms}).}
}
\value{
A logical descendancy matrix of \code{terms} by \code{terms} based on DAG structure of ontology. The row term is an ancestor of the column term if result[row.term,col.term] == TRUE.
}
\description{
Get logical descendancy matrix for set of terms
}
\examples{
data(hpo)
get_term_descendancy_matrix(hpo, c("HP:0001873", "HP:0011877"))
}

