% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{score}
\alias{score}
\title{Calculate the score for each horizon.}
\usage{
score(Residuals, scoreperiod = NA, usecomplete = TRUE, scorefun = rmse)
}
\arguments{
\item{Residuals}{A matrix with residuals (columns named \code{hxx}) for which to calculate the score for each horizon.}

\item{scoreperiod}{as a logical vector controlling which points to be included in the score calculation. If NA then all values are included.}

\item{usecomplete}{if TRUE then only the values available for all horizons are included (i.e. if at one time point there is a missing value, then values for this time point is removed for all horizons in the calculation).}

\item{scorefun}{The score function.}
}
\value{
A list with the a numeric vector with the score value for each horizon and the applied \code{scoreperiod} (note can be different from the given scoreperiod, if only complete observations are used (as per default)).
}
\description{
Calculates the score for each horizon for a matrix with residuals for each horizon.
}
\details{
Applies the \code{scorefun} on all horizons (each column) of the residuals matrix. See the description of each parameter for more details.
}
\examples{

# Just a vector to be forecasted
y <- c(filter(rnorm(100), 0.95, "recursive"))
# Generate a forecast matrix with a simple persistence model
Yhat <- persistence(y, kseq=1:4)
# The residuals for each horizon
Resid <- residuals(Yhat, y)

# Calculate the score for the k1 horizon
score(Resid)$scoreval

# The first values were excluded, since there are NAs
head(Resid)
score(Resid)$scoreperiod

}
