% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_fit.R
\name{lm_fit}
\alias{lm_fit}
\title{Fit an onlineforecast model with \code{\link{lm}}}
\usage{
lm_fit(
  prm = NA,
  model,
  data,
  scorefun = NA,
  returnanalysis = TRUE,
  printout = TRUE
)
}
\arguments{
\item{prm}{as numeric with the parameters to be used when fitting.}

\item{model}{object of class forecastmodel with the model to be fitted.}

\item{data}{as data.list with the data to fit the model on.}

\item{scorefun}{Optional. If scorefun is given, e.g. \code{\link{rmse}}, then the value of this is also returned.}

\item{returnanalysis}{as logical determining if the analysis should be returned. See below.}

\item{printout}{Defaults to TRUE. Prints the parameters for model.}
}
\value{
Depends on:

    - If \code{returnanalysis} is TRUE a list containing:

        * \code{Yhat}: data.frame with forecasts for \code{model$kseq} horizons.

        * \code{model}: The forecastmodel object cloned deep, so can be modified without changing the original object.

        * \code{data}: data.list with the data used, see examples on how to obtain the transformed data.

        * \code{Lfitval}: a character "Find the fits in model$Lfits", it's a list with the lm fits for each horizon.

        * \code{scoreval}: data.frame with the scorefun result on each horizon (only scoreperiod is included).

    - If \code{returnanalysis} is FALSE (and \code{scorefun} is given): The sum of the score function on all horizons (specified with model$kseq).
}
\description{
Fit a linear regression model given a onlineforecast model, seperately for each prediction horizon
}
\examples{

# Take data
D <- subset(Dbuilding, c("2010-12-15", "2011-01-01"))
D$y <- D$heatload
# Define a simple model 
model <- forecastmodel$new()
model$output <- "y"
model$add_inputs(Ta = "Ta",
                 mu = "one()")
model$add_regprm("rls_prm(lambda=0.99)")

# Before fitting the model, define which points to include in the evaluation of the score function
D$scoreperiod <- in_range("2010-12-20", D$t)
# And the sequence of horizons to fit for
model$kseq <- 1:6

# Now we can fit the model with RLS and get the model validation analysis data
fit <- lm_fit(prm=NA, model=model, data=D)
# What did we get back?
names(fit)
class(fit)
# The one-step forecast
plot(D$y, type="l")
lines(fit$Yhat$k1, col=2)
# Get the residuals
plot(residuals(fit)$h1)
# Score for each horizon
score_fit(fit)

# The lm_fit don't put anything in
fit$Lfitval
# Find the lm fits here
model$Lfits
# See result for k=1 horizon
summary(model$Lfits$k1)
# Some diurnal pattern is present
acf(residuals(fit)$h1, na.action=na.pass, lag.max=96)

}
