% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rf_snp_filter_onemap}
\alias{rf_snp_filter_onemap}
\title{Filter markers according with a two-points recombination fraction and LOD threshold. Adapted from MAPpoly.}
\usage{
rf_snp_filter_onemap(
  input.seq,
  thresh.LOD.rf = 5,
  thresh.rf = 0.15,
  probs = c(0.05, 1)
)
}
\arguments{
\item{input.seq}{an object of class \code{onemap}.}

\item{thresh.LOD.rf}{LOD score threshold for recombination fraction (default = 5)}

\item{thresh.rf}{threshold for recombination fractions (default = 0.15)}

\item{probs}{indicates the probability corresponding to the filtering quantiles. (default = c(0.05, 1))}
}
\value{
An object of class \code{sequence}, which is a list containing the
following components: \item{seq.num}{a \code{vector} containing the
(ordered) indices of markers in the sequence, according to the input file.}
\item{seq.phases}{a \code{vector} with the linkage phases between markers
in the sequence, in corresponding positions. \code{-1} means that there are
no defined linkage phases.} \item{seq.rf}{a \code{vector} with the
recombination frequencies between markers in the sequence. \code{-1} means
that there are no estimated recombination frequencies.}
\item{seq.like}{log-likelihood of the corresponding linkage map.}
\item{data.name}{object of class \code{onemap} with the raw
data.} \item{twopt}{object of class \code{rf_2pts} with the
2-point analyses.}
}
\description{
Filter markers according with a two-points recombination fraction and LOD threshold. Adapted from MAPpoly.
}
\examples{

 data("vcf_example_out")
 twopts <- rf_2pts(vcf_example_out)
 seq1 <- make_seq(twopts, which(vcf_example_out$CHROM == "1"))
filt_seq <- rf_snp_filter_onemap(seq1, 20, 0.5, c(0.5,1))

}
\author{
Cristiane Taniguti, \email{chtaniguti@tamu.edu}
}
