% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classCohortTable.R
\name{checkCohortRequirements}
\alias{checkCohortRequirements}
\title{Check whether a cohort table satisfies requirements}
\usage{
checkCohortRequirements(
  cohort,
  checkEndAfterStart = TRUE,
  checkOverlappingEntries = TRUE,
  checkMissingValues = TRUE,
  checkInObservation = TRUE,
  type = "error",
  call = parent.frame()
)
}
\arguments{
\item{cohort}{\code{cohort_table} object.}

\item{checkEndAfterStart}{If TRUE a check that all cohort end dates come on or
after cohort start date will be performed.}

\item{checkOverlappingEntries}{If TRUE a check that no individuals have overlapping
cohort entries will be performed.}

\item{checkMissingValues}{If TRUE a check that there are no missing values in
required fields will be performed.}

\item{checkInObservation}{If TRUE a check that cohort entries are within
the individuals observation periods will be performed.}

\item{type}{Can be either "error" or "warning". If "error" any check
failure will result in an error, whereas if "warning" any check failure
will result in a warning.}

\item{call}{The call for which to return the error message.}
}
\value{
An error will be returned if any of the selected checks fail.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
