% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.cohort_table}
\alias{summary.cohort_table}
\title{Summary a generated cohort set}
\usage{
\method{summary}{cohort_table}(object, ...)
}
\arguments{
\item{object}{A generated cohort set object.}

\item{...}{For compatibility (not used).}
}
\value{
A summarised_result object with a summary of a cohort_table.
}
\description{
Summary a generated cohort set
}
\examples{
library(dplyr, warn.conflicts = FALSE)

person <- tibble(
  person_id = 1, gender_concept_id = 0, year_of_birth = 1990,
  race_concept_id = 0, ethnicity_concept_id = 0
)
observation_period <- tibble(
  observation_period_id = 1, person_id = 1,
  observation_period_start_date = as.Date("2000-01-01"),
  observation_period_end_date = as.Date("2025-12-31"),
  period_type_concept_id = 0
)
cdm <- cdmFromTables(
  tables = list("person" = person, "observation_period" = observation_period),
  cdmName = "test",
  cohortTables = list("cohort1" = tibble(
    cohort_definition_id = 1,
    subject_id = 1,
    cohort_start_date = as.Date("2010-01-01"),
    cohort_end_date = as.Date("2010-01-05")
  ))
)

summary(cdm$cohort1)

}
