% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classCdmReference.R
\name{newCdmReference}
\alias{newCdmReference}
\title{\code{cdm_reference} objects constructor}
\usage{
newCdmReference(tables, cdmName, cdmVersion = NULL, .softValidation = FALSE)
}
\arguments{
\item{tables}{List of tables that are part of the OMOP Common Data Model
reference.}

\item{cdmName}{Name of the cdm object.}

\item{cdmVersion}{Version of the cdm. Supported versions 5.3 and 5.4.}

\item{.softValidation}{Whether to perform a soft validation of consistency.
If set to FALSE, non overlapping observation periods are ensured.}
}
\value{
A \code{cdm_reference} object.
}
\description{
\code{cdm_reference} objects constructor
}
\examples{
\donttest{
library(omopgenerics)
library(dplyr, warn.conflicts = FALSE)

cdmTables <- list(
  "person" = tibble(
    person_id = 1, gender_concept_id = 0, year_of_birth = 1990,
    race_concept_id = 0, ethnicity_concept_id = 0
  ) |>
    newCdmTable(newLocalSource(), "person"),
  "observation_period" = tibble(
    observation_period_id = 1, person_id = 1,
    observation_period_start_date = as.Date("2000-01-01"),
    observation_period_end_date = as.Date("2025-12-31"),
    period_type_concept_id = 0
  ) |>
    newCdmTable(newLocalSource(), "observation_period")
)
cdm <- newCdmReference(tables = cdmTables, cdmName = "mock")

cdm
}
}
