% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodBind.R
\name{bind.summarised_result}
\alias{bind.summarised_result}
\title{Bind two or summarised_result objects}
\usage{
\method{bind}{summarised_result}(...)
}
\arguments{
\item{...}{summarised_result objects}
}
\value{
A summarised_result object the merged objects.
}
\description{
Bind two or summarised_result objects
}
\examples{
library(omopgenerics)
library(dplyr, warn.conflicts = FALSE)

cdm <- cdmFromTables(
  tables = list(
    "person" = tibble(
      person_id = c(1, 2, 3), gender_concept_id = 0, year_of_birth = 1990,
      race_concept_id = 0, ethnicity_concept_id = 0
    ),
    "observation_period" = tibble(
      observation_period_id = 1:3, person_id = 1:3,
      observation_period_start_date = as.Date("2000-01-01"),
      observation_period_end_date = as.Date("2025-12-31"),
      period_type_concept_id = 0
    )
  ),
  cdmName = "mock",
  cohortTables = list("cohort1" = tibble(
    cohort_definition_id = 1,
    subject_id = 1:3,
    cohort_start_date = as.Date("2010-01-01"),
    cohort_end_date = as.Date("2010-01-05")
  ))
)

result1 <- summary(cdm)
result2 <- summary(cdm$cohort1)

mergedResult <- bind(result1, result2)
mergedResult

}
