% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_helpers.R
\name{impute}
\alias{impute}
\title{Impute function}
\usage{
impute(data, percent = 0.2)
}
\arguments{
\item{data}{A data frame containing the sample data. The first column should contain
the sample identifiers, and the rest of the columns contain the peaks.}

\item{percent}{A numeric value between 0 and 1 representing the threshold of the
percentage of NA values a feature should have for it to be removed from the dataset.
Default value is 0.2.}
}
\value{
A data frame with the first column as the sample identifiers and
the rest of the columns containing the cleaned and imputed peak intensities.
}
\description{
This function performs data cleaning and imputation on a given data matrix.
It removes blank and NIST samples, features with NA values more than the specified threshold,
and imputes remaining NA values with half of the smallest non-NA value.
}
\examples{

# Load the CSV data
data_file <- system.file("extdata", "example1.csv", package = "omicsTools")
data <- readr::read_csv(data_file)
# Apply the impute function
imputed_data <- omicsTools::impute(data, percent = 0.2)

\donttest{
# Write the imputed data to a new CSV file
readr::write_csv(imputed_data, paste0(tempdir(), "/imputed_data.csv"))
}
}
\author{
Yaoxiang Li \email{yl814@georgetown.edu}

Georgetown University, USA

License: GPL (>= 3)
}
