% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-dsresid-vs-pred-plot.R
\name{ols_plot_resid_stud_fit}
\alias{ols_plot_resid_stud_fit}
\title{Deleted studentized residual vs fitted values plot}
\usage{
ols_plot_resid_stud_fit(model, threshold = NULL, print_plot = TRUE)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{threshold}{Threshold for detecting outliers. Default is 2.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\value{
\code{ols_plot_resid_stud_fit} returns  a list containing the
following components:

\item{outliers}{a \code{data.frame} with observation number, fitted values and deleted studentized
residuals that exceed the \code{threshold} for classifying observations as
outliers/influential observations}
\item{threshold}{\code{threshold} for classifying an observation as an outlier/influential observation}
}
\description{
Plot for detecting violation of assumptions about residuals such as
non-linearity, constant variances and outliers. It can also be used to
examine model fit.
}
\details{
Studentized deleted residuals (or externally studentized residuals) is the
deleted residual divided by its estimated standard deviation. Studentized
residuals are going to be more effective for detecting outlying Y
observations than standardized residuals. If an observation has an externally
studentized residual that is larger than 2 (in absolute value) we can call
it an outlier.
}
\examples{
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_plot_resid_stud_fit(model)
ols_plot_resid_stud_fit(model, threshold = 3)

}
\seealso{
\code{\link[=ols_plot_resid_lev]{ols_plot_resid_lev()}}, \code{\link[=ols_plot_resid_stand]{ols_plot_resid_stand()}},
\code{\link[=ols_plot_resid_stud]{ols_plot_resid_stud()}}
}
