% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-information-criteria.R
\name{ols_aic}
\alias{ols_aic}
\title{Akaike information criterion}
\usage{
ols_aic(model, method = c("R", "STATA", "SAS"), corrected = FALSE)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{method}{A character vector; specify the method to compute AIC. Valid
options include R, STATA and SAS.}

\item{corrected}{Logical; if \code{TRUE}, returns corrected akaike information criterion for SAS method.}
}
\value{
Akaike information criterion of the model.
}
\description{
Akaike information criterion for model selection.
}
\details{
AIC provides a means for model selection. Given a collection of models for
the data, AIC estimates the quality of each model, relative to each of the
other models. R and STATA use loglikelihood to compute AIC. SAS uses residual
sum of squares. Below is the formula in each case:

\emph{R & STATA}
\deqn{AIC = -2(loglikelihood) + 2p}

\emph{SAS}
\deqn{AIC = n * ln(SSE / n) + 2p}

\emph{corrected}
\deqn{AIC = n * ln(SSE / n) + ((n * (n + p)) / (n - p - 2))}

where \emph{n} is the sample size and \emph{p} is the number of model parameters including intercept.
}
\examples{
# using R computation method
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_aic(model)

# using STATA computation method
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_aic(model, method = 'STATA')

# using SAS computation method
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_aic(model, method = 'SAS')

# corrected akaike information criterion
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_aic(model, method = 'SAS', corrected = TRUE)

}
\references{
Akaike, H. (1969). “Fitting Autoregressive Models for Prediction.” Annals of the Institute of Statistical
Mathematics 21:243–247.

Judge, G. G., Griffiths, W. E., Hill, R. C., and Lee, T.-C. (1980). The Theory and Practice of Econometrics.
New York: John Wiley & Sons.
}
\seealso{
Other model selection criteria: 
\code{\link{ols_apc}()},
\code{\link{ols_fpe}()},
\code{\link{ols_hsp}()},
\code{\link{ols_mallows_cp}()},
\code{\link{ols_msep}()},
\code{\link{ols_sbc}()},
\code{\link{ols_sbic}()}
}
\concept{model selection criteria}
