% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-all-possible-regression.R
\name{ols_step_all_possible_betas}
\alias{ols_step_all_possible_betas}
\alias{ols_all_subset_betas}
\title{All possible regression variable coefficients}
\usage{
ols_step_all_possible_betas(object, ...)
}
\arguments{
\item{object}{An object of class \code{lm}.}

\item{...}{Other arguments.}
}
\value{
\code{ols_step_all_possible_betas} returns a tibble containing:

\item{model_index}{model number}
\item{predictor}{predictor}
\item{beta_coef}{coefficient for the predictor}
}
\description{
Returns the coefficients for each variable from each model.
}
\examples{
\dontrun{
model <- lm(mpg ~ disp + hp + wt, data = mtcars)
ols_step_all_possible_betas(model)
}

}
