% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-standardized-residual-chart.R
\name{ols_plot_resid_stand}
\alias{ols_plot_resid_stand}
\alias{ols_srsd_chart}
\title{Standardized residual chart}
\usage{
ols_plot_resid_stand(model)
}
\arguments{
\item{model}{An object of class \code{lm}.}
}
\value{
\code{ols_plot_resid_stand} returns  a list containing the
following components:

\item{outliers}{a tibble with observation number and \code{standardized resiudals} that
exceed \code{threshold}} for classifying an observation as an outlier
\item{threshold}{\code{threshold} for classifying an observation as an outlier}
}
\description{
Chart for identifying outliers.
}
\details{
Standardized residual (internally studentized) is the residual divided by
estimated standard deviation.
}
\section{Deprecated Function}{

\code{ols_srsd_chart()} has been deprecated. Instead use \code{ols_plot_resid_stand()}.
}

\examples{
model <- lm(mpg ~ disp + hp + wt, data = mtcars)
ols_plot_resid_stand(model)

}
\seealso{
[ols_plot_resid_stud()]
}
